#include <iostream>
#include <numeric>
#include <cstdint>
#include <vector>
#include <string>

constexpr int N_MAX = 100'000 + 1;

int niz[N_MAX];
int n;

std::vector<int> q_niz;
std::vector<bool> iskoristeni;

class Max
{
public:
    Max() :
        m_max(INT64_MIN), m_is_set(false) {}

    void set_max(int num)
    {
        if (num > m_max)
        {
            m_is_set = true;
            m_max = num;
            m_output_vector = q_niz;
        }
    }

    int64_t get_max()
    {
        return m_max;
    }

    bool is_set()
    {
        return m_is_set;
    }

    void reset()
    {
        m_max = INT64_MIN;
        m_is_set = false;
    }

    const std::vector<int>& get_vec()
    {
        return m_output_vector;
    }

private:
    int64_t m_max;
    bool m_is_set;
    std::vector<int> m_output_vector;
};

Max max;

void nadji_max(int suma)
{
    if (q_niz.size() == n)
    {
        max.set_max(suma);
        return;
    }
    
    for (int i = 0; i < n; i++)
    {
        if (iskoristeni[i])
            continue;

        q_niz.push_back(i);
        iskoristeni[i] = true;
        
        nadji_max(suma + niz[q_niz.size() - 1] ^ q_niz.back());
        iskoristeni[i] = false;
        q_niz.pop_back();
    }
}

int main(int argc, char const *argv[])
{
    int t;
    std::cin >> t;
    std::string izlaz;

    q_niz.reserve(N_MAX);
    iskoristeni.resize(N_MAX);

    while (t--)
    {
        std::cin >> n;
        n++;

        for (int i = 0; i < n; i++)
            std::cin >> niz[i];

        for (int i = 0; i < n; i++)
            iskoristeni[i] = false;

        q_niz.clear();
        max.reset();

        nadji_max(0);
        izlaz += std::to_string(max.get_max()) + '\n';

        for (int a : max.get_vec())
            izlaz += std::to_string(a) + ' ';

        izlaz += '\n';
    }

    std::cout << izlaz;
}